/************************************************************************
 *
 * \file: AutoSmoketest.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 *  implements functionality to automate the smoketest.
 * <detailed description>
 * \component: Android Auto - Demo application
 *
 * \author: Ajay Kumar Sahoo / RBEI/ECF3 /ajaykumar.sahoo@in.bosch.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/
#ifndef AAUTOT_AUTOSMOKETEST_H
#define AAUTOT_AUTOSMOKETEST_H

#include <string>
#include <list>
#include <condition_variable>
#include <mutex>
#include <uspi/FeatureDiscoveryTypes.h>
#include "utility/Singleton.h"
#include "utils/IStoppable.h"

namespace adit { namespace aauto {

typedef enum
{
    MANUAL,
    AUTOMATIC,
} testMode ;

typedef enum
{
    NODEVICE            = -1,
    AOAPNOTSUPPORTED    = -2,
    DEVICEALREADYINAOAP = -3,
    DEVICENOTSWITCHED   = -4,
    GSTINTERNAL         = -5,

    NOERROR             = 0,
    DEVICESWITCHED      = 1,
    AAPSTARTED          = 2,
    VIDEOFRAMERENDERED  = 3,
    DONE                = 4
} testError;

// Automatic Smoketest
class AutoSmoketest : public adit::utility::Singleton<AutoSmoketest>, public IStoppable
{
public:
    AutoSmoketest();
    ~AutoSmoketest();

    void cleanAutoSmoketest();

    //for automatic smoketest
    void     setTestMode(testMode mode) { stMode = mode; }
    testMode getTestMode() { return stMode; }

    void setSmoketestTimeout(int timeout) { stTimeout = timeout; }

    void         setTestError(testError err);
    testError    getTestError() { return stError; }
    std::string& getErrorString(void);

    void setTestResult(int inTestResult) { mTestResult = inTestResult; }
    int  getTestResult(void) { return mTestResult; }

    void addDevice(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inDeviceToAdd);
    void removeDevice(void);
    std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> getTestDevice(void);
    std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> getTestDevice(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDev);

    std::list<std::shared_ptr<adit::uspi::DiscoveredDeviceUsb>>& getUsbDevInfoList() { return usbDevInfos; };

    void setDisplayId(int id) { displayId = id; }
    int  getDisplayId() { return displayId; }


    void waitForExit();

    // IStoppable implementation
    void requestStop();

    void setDumpDelay(int inTimeout) { mGraphicDumpDelay = inTimeout; }
    int  getDumpDelay(void) { return mGraphicDumpDelay; }

    //handle timer
    void createSignalTimer(void);
    void startSignalTimer(void);
    void setSignalTimer(void);
    void deleteSignalTimer(void);

private:
    testMode   stMode;
    testError  stError;
    timer_t    timerid;
    bool       timerCreated;
    int        stTimeout;
    int        displayId;
    std::string     errString;
    std::list<std::shared_ptr<adit::uspi::DiscoveredDeviceUsb>> usbDevInfos; //for resetting
    std::mutex mMtxDevInfos;

    int        mGraphicDumpDelay;
    std::condition_variable mCvWaitForExit;
    std::mutex mMtxWaitForExit;
    int        mTestResult;
};
} } /* namespace adit { namespace aauto */
#endif /* AAUTOT_AUTOSMOKETEST_H */
